/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.Converter;
import eu.simuline.m2latex.core.ConverterCategory;
import eu.simuline.m2latex.core.Injection;
import eu.simuline.m2latex.core.LatexDev;
import eu.simuline.m2latex.core.LatexmkUsage;
import eu.simuline.m2latex.core.RuntimeParameter;
import eu.simuline.m2latex.core.Target;
import eu.simuline.m2latex.core.TargetsContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugins.annotations.Parameter;

public class Settings {
    public static final String PARAM_PROP = "latex.injections";
    private static final String GRP_NAME = "name";
    private static final String GRP_METHOD = "method";
    private static final Pattern PATTERN_CONFIG = Pattern.compile((String)"\\$\\{(?<name>\\w+)(?<method>\\(\\))?\\}");
    private static final Pattern NEVER_MATCH = Pattern.compile((String)"[a&&[^a]]");
    static final String SST;
    static final String GRP_IDENT = "$";
    @RuntimeParameter
    private File baseDirectory;
    private File targetDirectory;
    private File targetSiteDirectory;
    @RuntimeParameter
    @Parameter(name="texSrcDirectory", defaultValue="src${file.separator}site${file.separator}tex")
    private String texSrcDirectory = SST;
    private File texSrcDirectoryFile = new File(this.texSrcDirectory);
    @RuntimeParameter
    @Parameter(name="texSrcProcDirectory", defaultValue=".")
    private String texSrcProcDirectory = ".";
    private File texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
    @RuntimeParameter
    @Parameter(name="readTexSrcProcDirRec", defaultValue="true")
    private boolean readTexSrcProcDirRec = true;
    @RuntimeParameter
    @Parameter(name="outputDirectory", defaultValue=".")
    private String outputDirectory = ".";
    private File outputDirectoryFile = new File(this.targetSiteDirectory, this.outputDirectory);
    @RuntimeParameter
    @Parameter(name="diffDirectory", defaultValue="src${file.separator}main${file.separator}resources${file.separator}docsCmp")
    private String diffDirectory = "src/main/resources/docsCmp";
    private File diffDirectoryFile = new File(this.baseDirectory, this.diffDirectory);
    @RuntimeParameter
    @Parameter(name="targets", defaultValue="chk,pdf,html", property="latex.targets")
    private String targets = "chk,pdf,html";
    @RuntimeParameter
    @Parameter(name="convertersExcluded", defaultValue="")
    private String convertersExcluded = "";
    @RuntimeParameter
    @Parameter(name="patternLatexMainFile")
    private String patternLatexMainFile = "\\A(%\\s*!\\s*T[eE]X (TXS|spellcheck|encoding|root).*\\R)*(%\\s*!\\s*T[eE]X program\\s*=\\s*(?<programMagic>[^} ]+)\\R)?(%\\s*!\\s*T[eE]X .*\\R)*(%\\s*!\\s*LMP (?<chkDiffMagic>chkDiff)(=(?<chkDiffMagicVal>true|false))?\\R)?(%\\s*!\\s*LMP (?<latexmkMagic>latexmk)(=(?<latexmkMagicVal>true|false))?\\R)?(%\\s*!\\s*LMP targets=(?<targetsMagic>(\\p{Lower}|,)+)\\R)?(\\s*(\\\\RequirePackage\\s*(\\[(\\s|\\w|[,=])*\\])?\\s*\\{(\\w|-)+\\}\\s*(\\[(\\d|[-./])+\\])?|\\\\PassOptionsToPackage\\s*\\{(\\s|\\w|[,=])*\\}\\s*\\{(\\w|-)+\\}|\\\\newbool\\s*\\{\\w+\\}|\\\\setbool\\s*\\{\\w+\\}\\{(true|false)\\}|\\\\UseName\\s*\\{[^{}]*\\}(?<arg>\\{(?:[^{}]|(?'arg'))*\\})*|\\\\DocumentMetadata(?<docMetadata>\\{(?:[^{}]|(?'docMetadata'))*\\})|\\\\input\\s*\\{[^{}]*\\})?\\s*(%.*)?\\R)*\\\\(documentstyle|documentclass)\\s*(\\[[^]]*\\])?\\s*\\{(?<docClass>[^} ]+)\\}";
    private static final Pattern PATTERN_REF_INGERL;
    private static final String FORMAT_REF_PERL = "(?&%s)";
    @RuntimeParameter
    @Parameter(name="docClassesToTargets")
    private String docClassesToTargets = "article,report,book,minimal:chk,dvi,pdf,html,odt,docx,rtf,txt\nbeamer,leaflet,scrlttr2:chk,pdf,txt";
    @RuntimeParameter
    @Parameter(name="mainFilesIncluded", defaultValue="")
    private String mainFilesIncluded = "";
    @RuntimeParameter
    @Parameter(name="mainFilesExcluded", defaultValue="")
    private String mainFilesExcluded = "";
    @RuntimeParameter
    @Parameter(name="latexmkUsage", defaultValue="NotAtAll")
    private LatexmkUsage latexmkUsage = LatexmkUsage.NotAtAll;
    @RuntimeParameter
    @Parameter(name="texPath", defaultValue="null")
    private File texPath = null;
    @RuntimeParameter
    @Parameter(name="chkDiff", defaultValue="false")
    private boolean chkDiff = false;
    @RuntimeParameter
    @Parameter(name="cleanUp", defaultValue="true")
    private boolean cleanUp = true;
    @RuntimeParameter
    @Parameter(name="patternCreatedFromLatexMain")
    private String patternCreatedFromLatexMain = "^(T$T(\\.([^.]*|synctex(\\(busy\\))?(\\.gz)?|out\\.ps|run\\.xml|\\d+\\.vrb|depytx(\\.tex)?)|(-|ch|se|su|ap|li)?\\d+\\.x?html?|\\d+x\\.x?bb|\\d+x?\\.png|-\\d+\\.svg|-.+\\.(idx|ind|ilg))|pythontex-files-T$T|zzT$T\\.e?ps|(cmsy)\\d+(-c)?-\\d+c?\\.png|(pdf|xe|lua)?latex\\d+\\.fls|pdf[xae]\\.xmpi?|texput\\.(fls|log))$";
    @RuntimeParameter
    @Parameter(name="fig2devCommand", defaultValue="fig2dev")
    private String fig2devCommand = "fig2dev";
    @RuntimeParameter
    @Parameter(name="fig2devGenOptions", defaultValue="")
    private String fig2devGenOptions = "";
    @RuntimeParameter
    @Parameter(name="fig2devPtxOptions", defaultValue="")
    private String fig2devPtxOptions = "";
    @RuntimeParameter
    @Parameter(name="fig2devPdfEpsOptions", defaultValue="")
    private String fig2devPdfEpsOptions = "";
    @RuntimeParameter
    @Parameter(name="gnuplotCommand", defaultValue="gnuplot")
    private String gnuplotCommand = "gnuplot";
    @RuntimeParameter
    @Parameter(name="gnuplotOptions", defaultValue="")
    private String gnuplotOptions = "";
    @RuntimeParameter
    @Parameter(name="metapostCommand", defaultValue="mpost")
    private String metapostCommand = "mpost";
    @RuntimeParameter
    @Parameter(name="metapostOptions", defaultValue="-interaction=nonstopmode -recorder -s prologues=2 -s outputtemplate=\"%j.mps\"")
    private String metapostOptions = "-interaction=nonstopmode -recorder -s prologues=2 -s outputtemplate=\"%j.mps\"";
    @RuntimeParameter
    @Parameter(name="patternErrMPost", defaultValue="(^! )")
    private String patternErrMPost = "(^! )";
    @RuntimeParameter
    @Parameter(name="patternWarnMPost", defaultValue="^([Ww]arning: )")
    private String patternWarnMPost = "^([Ww]arning: )";
    @RuntimeParameter
    @Parameter(name="svg2devCommand", defaultValue="inkscape")
    private String svg2devCommand = "inkscape";
    @RuntimeParameter
    @Parameter(name="svg2devOptions", defaultValue="--export-area-drawing --export-latex")
    private String svg2devOptions = "--export-area-drawing --export-latex";
    @RuntimeParameter
    @Parameter(name="createBoundingBoxes", defaultValue="false")
    private boolean createBoundingBoxes = false;
    @RuntimeParameter
    @Parameter(name="ebbCommand", defaultValue="extractbb")
    private String ebbCommand = "extractbb";
    @RuntimeParameter
    @Parameter(name="ebbOptions", defaultValue="-v")
    private String ebbOptions = "-v";
    @RuntimeParameter
    @Parameter(name="latex2pdfCommand", defaultValue="lualatex")
    private String latex2pdfCommand = "lualatex";
    @RuntimeParameter
    @Parameter(name="latex2pdfOptions", defaultValue="-interaction=nonstopmode -synctex=1 -recorder -shell-escape")
    private String latex2pdfOptions = "-interaction=nonstopmode -synctex=1 -recorder -shell-escape";
    @RuntimeParameter
    @Parameter(name="patternErrLatex", defaultValue="(^! )")
    private String patternErrLatex = "(^! )";
    @RuntimeParameter
    @Parameter(name="patternWarnLatex", defaultValue="^(LaTeX Warning: |LaTeX Font Warning: |(Package|Class) .+ Warning: |pdfTeX warning( \\((\\d|\\w)+\\))?: |warning  \\(file .+\\) \\(pdf inclusion\\): PDF inclusion: |\\* fontspec warning: |Non-PDF special ignored!|Missing character: There is no .* in font .*!$|A space is missing\\. (No warning)\\.)")
    private String patternWarnLatex = "^(LaTeX Warning: |LaTeX Font Warning: |(Package|Class) .+ Warning: |pdfTeX warning( \\((\\d|\\w)+\\))?: |\\* fontspec warning: |warning  \\(file .+\\) \\(pdf inclusion\\): PDF inclusion: |\\* fontspec warning: |Non-PDF special ignored!|Missing character: There is no .* in font .*!$|A space is missing\\. (No warning)\\.)";
    @RuntimeParameter
    @Parameter(name="debugBadBoxes", defaultValue="true")
    private boolean debugBadBoxes = true;
    @RuntimeParameter
    @Parameter(name="debugWarnings", defaultValue="true")
    private boolean debugWarnings = true;
    @RuntimeParameter
    @Parameter(name="pdfViaDvi", defaultValue="false")
    private boolean pdfViaDvi = false;
    @RuntimeParameter
    @Parameter(name="dvi2pdfCommand", defaultValue="dvipdfmx")
    private String dvi2pdfCommand = "dvipdfmx";
    @RuntimeParameter
    @Parameter(name="dvi2pdfOptions", defaultValue="")
    private String dvi2pdfOptions = "-V1.7";
    @RuntimeParameter
    @Parameter(name="patternReRunLatex", defaultValue="^(LaTeX Warning: Label\\(s\\) may have changed\\. Rerun to get cross-references right\\.$|Package \\w+ Warning: .*Rerun( .*|\\.)$|Package rerunfilecheck Info: Checksums for |Package \\w+ Warning: .*$^\\(\\w+\\) .*Rerun( .*|\\.)$|LaTeX Warning: Etaremune labels have changed\\.$|\\(rerunfilecheck\\)                Rerun to get outlines right$|\\(rerunfilecheck\\)                Rerun LaTeX)")
    private String patternReRunLatex = "^(LaTeX Warning: Label\\(s\\) may have changed\\. Rerun to get cross-references right\\.$|Package \\w+ Warning: .*Rerun( .*|\\.)$|Package rerunfilecheck Info: Checksums for |Package \\w+ Warning: .*$^\\(\\w+\\) .*Rerun( .*|\\.)$|LaTeX Warning: Etaremune labels have changed\\.$|\\(rerunfilecheck\\)                Rerun to get outlines right$|\\(rerunfilecheck\\)                Rerun LaTeX)";
    @RuntimeParameter
    @Parameter(name="maxNumReRunsLatex", defaultValue="5")
    private int maxNumReRunsLatex = 5;
    @RuntimeParameter
    @Parameter(name="bibtexCommand", defaultValue="bibtex")
    private String bibtexCommand = "bibtex";
    @RuntimeParameter
    @Parameter(name="bibtexOptions", defaultValue="")
    private String bibtexOptions = "";
    @RuntimeParameter
    @Parameter(name="patternErrBibtex", defaultValue="error message")
    private String patternErrBibtex = "error message";
    @RuntimeParameter
    @Parameter(name="patternWarnBibtex", defaultValue="^Warning--")
    private String patternWarnBibtex = "^Warning--";
    @RuntimeParameter
    @Parameter(name="patternMultiIndex", defaultValue="^(\\\\indexentry)\\[([^]]*)\\](.*)$")
    private String patternMultiIndex = "^(\\\\indexentry)\\[([^]]*)\\](.*)$";
    @RuntimeParameter
    @Parameter(name="makeIndexCommand", defaultValue="makeindex")
    private String makeIndexCommand = "makeindex";
    @RuntimeParameter
    @Parameter(name="makeIndexOptions", defaultValue="")
    private String makeIndexOptions = "";
    @RuntimeParameter
    @Parameter(name="patternErrMakeIndex", defaultValue="(!! Input index error )")
    private String patternErrMakeIndex = "(!! Input index error )";
    @RuntimeParameter
    @Parameter(name="patternWarnMakeIndex", defaultValue="(## Warning )")
    private String patternWarnMakeIndex = "(## Warning )";
    @RuntimeParameter
    @Parameter(name="splitIndexCommand", defaultValue="splitindex")
    private String splitIndexCommand = "splitindex";
    @RuntimeParameter
    @Parameter(name="splitIndexOptions", defaultValue="-V")
    private String splitIndexOptions = "-V";
    @RuntimeParameter
    @Parameter(name="makeGlossariesCommand", defaultValue="makeglossaries")
    private String makeGlossariesCommand = "makeglossaries";
    @RuntimeParameter
    @Parameter(name="makeGlossariesOptions", defaultValue="")
    private String makeGlossariesOptions = "";
    @RuntimeParameter
    @Parameter(name="patternErrMakeGlossaries", defaultValue="^makeglossaries diagnostic messages:$")
    private String patternErrMakeGlossaries = "^makeglossaries diagnostic messages:$";
    @RuntimeParameter
    @Parameter(name="patternErrXindy", defaultValue="(^ERROR: )")
    private String patternErrXindy = "(^ERROR: )";
    @RuntimeParameter
    @Parameter(name="patternWarnXindy", defaultValue="(^WARNING: )")
    private String patternWarnXindy = "(^WARNING: )";
    @RuntimeParameter
    @Parameter(name="pythontexCommand", defaultValue="pythontex")
    private String pythontexCommand = "pythontex";
    @RuntimeParameter
    @Parameter(name="pythontexOptions", defaultValue="--rerun=always")
    private String pythontexOptions = "--rerun=always";
    @RuntimeParameter
    @Parameter(name="patternErrPyTex", defaultValue="\\* PythonTeX error|(PythonTeX:  .+ -|    - Current: ) [1-9][0-9]* error\\(s\\), [0-9]+ warning\\(s\\)")
    private String patternErrPyTex = "\\* PythonTeX error|(PythonTeX:  .+ -|    - Current: ) [1-9][0-9]* error\\(s\\), [0-9]+ warning\\(s\\)";
    @RuntimeParameter
    @Parameter(name="patternWarnPyTex", defaultValue="(PythonTeX:  .+ -|    - Current: ) [0-9]+ error\\(s\\), [1-9][0-9]* warning\\(s\\)")
    private String patternWarnPyTex = "(PythonTeX:  .+ -|    - Current: ) [0-9]+ error\\(s\\), [1-9][0-9]* warning\\(s\\)";
    @RuntimeParameter
    @Parameter(name="pythontex-files-", defaultValue="pythontex-files-", readonly=true)
    private String prefixPytexOutFolder = "pythontex-files-";
    @RuntimeParameter
    @Parameter(name="depythontexCommand", defaultValue="depythontex")
    private String depythontexCommand = "depythontex";
    @RuntimeParameter
    @Parameter(name="depythontexOptions", defaultValue="")
    private String depythontexOptions = "";
    @RuntimeParameter
    @Parameter(name="tex4htCommand", defaultValue="htlatex")
    private String tex4htCommand = "htlatex";
    @RuntimeParameter
    @Parameter(name="tex4htStyOptions", defaultValue="html,2")
    private String tex4htStyOptions = "html,2";
    @RuntimeParameter
    @Parameter(name="tex4htOptions", defaultValue="")
    private String tex4htOptions = "";
    @RuntimeParameter
    @Parameter(name="t4htOptions", defaultValue="")
    private String t4htOptions = "";
    @RuntimeParameter
    @Parameter(name="patternT4htOutputFiles", defaultValue="")
    private String patternT4htOutputFiles = "^(T$T(((ch|se|su|ap|li)?\\d+)?\\.x?html?|\\.css|\\d+x\\.x?bb|\\d+x\\.png|-\\d+\\.svg)|(cmsy)\\d+(-c)?-\\d+c?\\.png)$";
    @RuntimeParameter
    @Parameter(name="latex2rtfCommand", defaultValue="latex2rtf")
    private String latex2rtfCommand = "latex2rtf";
    @RuntimeParameter
    @Parameter(name="latex2rtfOptions", defaultValue="")
    private String latex2rtfOptions = "";
    @RuntimeParameter
    @Parameter(name="odt2docCommand", defaultValue="odt2doc")
    private String odt2docCommand = "odt2doc";
    @RuntimeParameter
    @Parameter(name="odt2docOptions", defaultValue="-fdocx")
    private String odt2docOptions = "-fdocx";
    @RuntimeParameter
    @Parameter(name="pdf2txtCommand", defaultValue="pdftotext")
    private String pdf2txtCommand = "pdftotext";
    @RuntimeParameter
    @Parameter(name="pdf2txtOptions", defaultValue="-q")
    private String pdf2txtOptions = "-q";
    @RuntimeParameter
    @Parameter(name="chkTexCommand", defaultValue="chktex")
    private String chkTexCommand = "chktex";
    @RuntimeParameter
    @Parameter(name="chkTexOptions", defaultValue="-q -b0")
    private String chkTexOptions = "-q -b0";
    @RuntimeParameter
    @Parameter(name="diffPdfCommand", defaultValue="diff")
    private String diffPdfCommand = "diff";
    @RuntimeParameter
    @Parameter(name="pdfMetainfoCommand", defaultValue="pdfinfo")
    private String pdfMetainfoCommand = "pdfinfo";
    @RuntimeParameter
    @Parameter(name="pdfMetainfoOptions", defaultValue="-isodates")
    private String pdfMetainfoOptions = "-isodates";
    @RuntimeParameter
    @Parameter(name="pdfMetainfoXmpOptions", defaultValue="-meta")
    private String pdfMetainfoXmpOptions = "-meta";
    @RuntimeParameter
    @Parameter(name="latexmkCommand", defaultValue="latexmk")
    private String latexmkCommand = "latexmk";
    @RuntimeParameter
    @Parameter(name="latexmkOptions", defaultValue="")
    private String latexmkOptions = "";
    @RuntimeParameter
    @Parameter(name="verifyStdCommand", defaultValue="verapdf")
    private String verifyStdCommand = "verapdf";
    @RuntimeParameter
    @Parameter(name="verifyStdOptions", defaultValue="-f 0 --format text")
    private String verifyStdOptions = "-f 0 --format text";
    @RuntimeParameter
    @Parameter(name="verifyByCmp", defaultValue="true")
    private boolean verifyByCmp = true;

    static {
        String fs = System.getProperty("file.separator");
        SST = "src" + fs + "site" + fs + "tex";
        PATTERN_REF_INGERL = Pattern.compile((String)"\\(\\?'(\\w+)'\\)");
    }

    private static String convertIngerlToPerl(String patternIngerl) {
        Matcher matcher = PATTERN_REF_INGERL.matcher((CharSequence)patternIngerl);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String groupName = matcher.group(1);
            matcher.appendReplacement(sb, String.format(FORMAT_REF_PERL, groupName));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @RuntimeParameter
    public String patternLatexMainFilePerl() {
        return Settings.convertIngerlToPerl(this.getPatternLatexMainFile());
    }

    public File getTexSrcDirectoryFile() throws BuildFailureException {
        if (!this.texSrcDirectoryFile.exists() || !this.texSrcDirectoryFile.isDirectory()) {
            throw new BuildFailureException("TSS01: The tex source directory '" + String.valueOf(this.texSrcDirectoryFile) + "' should be an existing directory, but is not. ");
        }
        return this.texSrcDirectoryFile;
    }

    public File getTexSrcProcDirectoryFile() throws BuildFailureException {
        if (!this.texSrcProcDirectoryFile.exists() || !this.texSrcProcDirectoryFile.isDirectory()) {
            throw new BuildFailureException("TSS02: The tex source processing directory '" + String.valueOf(this.texSrcProcDirectoryFile) + "' should be an existing directory, but is not. ");
        }
        return this.texSrcProcDirectoryFile;
    }

    public boolean getReadTexSrcProcDirRec() {
        return this.readTexSrcProcDirRec;
    }

    public File getOutputDirectoryFile() throws BuildFailureException {
        if (this.outputDirectoryFile.exists() && !this.outputDirectoryFile.isDirectory()) {
            throw new BuildFailureException("TSS03: The output directory '" + String.valueOf(this.outputDirectoryFile) + "' should be a directory if it exists, but is not. ");
        }
        return this.outputDirectoryFile;
    }

    public File getDiffDirectoryFile() throws BuildFailureException {
        if (this.diffDirectoryFile.exists() && !this.diffDirectoryFile.isDirectory()) {
            throw new BuildFailureException("TSS09: The diff directory '" + String.valueOf(this.diffDirectoryFile) + "' should be a directory if it exists, but is not. ");
        }
        return this.diffDirectoryFile;
    }

    public SortedSet<Target> getTargets() throws BuildFailureException {
        return Settings.getTargets(this.targets, TargetsContext.targetsSetting);
    }

    static SortedSet<Target> getTargets(String targetsChunksStr, TargetsContext targetContext) throws BuildFailureException {
        TreeSet<Target> targetsSet = new TreeSet<Target>();
        if (targetsChunksStr.isEmpty()) {
            return targetsSet;
        }
        String[] targetSeq = targetsChunksStr.split(",");
        int idx = 0;
        while (idx < targetSeq.length) {
            assert (targetSeq[idx] != null);
            String targetStr = targetSeq[idx];
            Settings.readTargetChecked(targetStr, targetsSet, targetsChunksStr, targetContext);
            ++idx;
        }
        return targetsSet;
    }

    private static void readTargetChecked(String targetStr, Set<Target> targetsSet, String targetsChunksStr, TargetsContext targetsContext) throws BuildFailureException {
        try {
            Target target = Target.valueOf(targetStr);
            boolean isNew = targetsSet.add(target);
            if (!isNew) {
                throw new BuildFailureException("TSS11: The target set '" + targetsChunksStr + "' in " + targetsContext.context() + " repeats target '" + String.valueOf((Object)target) + "'. ");
            }
        }
        catch (IllegalArgumentException ae) {
            assert (Target.class.isEnum());
            throw new BuildFailureException("TSS04: The target set '" + targetsChunksStr + "' in " + targetsContext.context() + " contains the invalid target '" + targetStr + "'. ");
        }
    }

    public SortedSet<Converter> getConvertersExcluded() throws BuildFailureException {
        TreeSet<Converter> convSet = new TreeSet<Converter>();
        if (this.convertersExcluded.isEmpty()) {
            return convSet;
        }
        String[] convSeq = this.convertersExcluded.split(" *, *");
        int idx = 0;
        while (idx < convSeq.length) {
            Converter conv = Converter.cmd2Conv(convSeq[idx]);
            if (conv == null) {
                throw new BuildFailureException("TSS05: The excluded converters '" + this.convertersExcluded + "' should form a subset of the registered converters '" + Converter.toCommandsString() + "'. ");
            }
            convSet.add(conv);
            ++idx;
        }
        return convSet;
    }

    private String checkConverterName(String convStr, ConverterCategory cat) throws BuildFailureException {
        int idxLastCol = convStr.lastIndexOf(58);
        if (idxLastCol != -1) {
            String catStr = convStr.substring(idxLastCol + 1);
            String convStrProper = convStr.substring(0, idxLastCol);
            if (!cat.getExtName().equals(catStr)) {
                throw new BuildFailureException("TSS10: Specified unregistered converter '" + convStrProper + "' with invalid category '" + catStr + "'; should be '" + cat.getExtName() + "''. ");
            }
            return convStrProper;
        }
        Converter conv = Converter.cmd2Conv(convStr);
        if (conv == null) {
            throw new BuildFailureException("TSS06: Tried to use converter '" + convStr + "' although not among the registered converters '" + Converter.toCommandsString() + "' as expected. ");
        }
        SortedSet<Converter> convertersExcluded = this.getConvertersExcluded();
        if (convertersExcluded.contains((Object)conv)) {
            throw new BuildFailureException("TSS07: Tried to use converter '" + convStr + "' although among the excluded converters '" + Converter.toCommandsString(convertersExcluded) + "'. ");
        }
        if (conv.getCategory() != cat) {
            throw new BuildFailureException("TSS08: Tried to use converter '" + convStr + "' in configuration '" + cat.getCommandFieldname() + "' instead of configuration '" + conv.getCategory().getCommandFieldname() + "'. ");
        }
        return convStr;
    }

    public String getPatternLatexMainFile() {
        return this.patternLatexMainFile;
    }

    public Map<String, Set<Target>> getDocClassesToTargets() throws BuildFailureException {
        String[] chunks;
        TreeMap<String, Set<Target>> result = new TreeMap<String, Set<Target>>();
        String[] stringArray = chunks = this.docClassesToTargets.trim().split("\\s+");
        int n = chunks.length;
        int n2 = 0;
        while (n2 < n) {
            String chunk = stringArray[n2];
            int idxCol1 = chunk.indexOf(58);
            int idxCol2 = chunk.lastIndexOf(58);
            if (idxCol1 == -1 || idxCol1 == 0 || idxCol1 != idxCol2) {
                throw new BuildFailureException("TSS12: Invalid mapping '" + chunk + "' of document classes to targets. ");
            }
            String targetsStr = chunk.substring(idxCol1 + 1);
            SortedSet<Target> targetsSet = Settings.getTargets(targetsStr, TargetsContext.inChunkSetting);
            String classesStr = chunk.substring(0, idxCol1);
            String[] stringArray2 = classesStr.split(",");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String cls = stringArray2[n4];
                Set oldTargetSet = result.put(cls, targetsSet);
                if (oldTargetSet != null) {
                    throw new BuildFailureException("TSS13: For document class '" + cls + "' target set is not unique. ");
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public Set<String> getMainFilesIncluded() {
        return this.mainFilesIncluded.isEmpty() ? new HashSet<String>() : new HashSet<String>(Arrays.asList(this.mainFilesIncluded.split(" ")));
    }

    public Set<String> getMainFilesExcluded() {
        return this.mainFilesExcluded.isEmpty() ? new HashSet<String>() : new HashSet<String>(Arrays.asList(this.mainFilesExcluded.split(" ")));
    }

    public LatexmkUsage getLatexmkUsage() {
        return this.latexmkUsage;
    }

    public File getTexPath() {
        return this.texPath;
    }

    public boolean isCleanUp() {
        return this.cleanUp;
    }

    public boolean isChkDiff() {
        return this.chkDiff;
    }

    public String getPatternCreatedFromLatexMain() {
        return this.patternCreatedFromLatexMain;
    }

    @RuntimeParameter
    public String getFig2devCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Fig2Dev);
    }

    public String getFig2devGenOptions() {
        return this.fig2devGenOptions;
    }

    public String getFig2devPtxOptions() {
        return this.fig2devPtxOptions;
    }

    public String getFig2devPdfEpsOptions() {
        return this.fig2devPdfEpsOptions;
    }

    @RuntimeParameter
    public String getGnuplotCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Gnuplot2Dev);
    }

    public String getGnuplotOptions() {
        return this.gnuplotOptions;
    }

    @RuntimeParameter
    public String getMetapostCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.MetaPost);
    }

    public String getMetapostOptions() {
        return this.metapostOptions;
    }

    public String getPatternErrMPost() {
        return this.patternErrMPost;
    }

    public String getPatternWarnMPost() {
        return this.patternWarnMPost;
    }

    @RuntimeParameter
    public String getSvg2devCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Svg2Dev);
    }

    public String getSvg2devOptions() {
        return this.svg2devOptions;
    }

    public boolean getCreateBoundingBoxes() {
        return this.createBoundingBoxes;
    }

    @RuntimeParameter
    public String getEbbCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.EbbCmd);
    }

    public String getEbbOptions() {
        return this.ebbOptions;
    }

    @RuntimeParameter
    public String getLatex2pdfCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.LaTeX);
    }

    public String getLatex2pdfOptions() {
        return this.latex2pdfOptions;
    }

    public String getPatternErrLatex() {
        return this.patternErrLatex;
    }

    public String getPatternWarnLatex() {
        return this.patternWarnLatex;
    }

    public boolean getDebugBadBoxes() {
        return this.debugBadBoxes;
    }

    public boolean getDebugWarnings() {
        return this.debugWarnings;
    }

    public LatexDev getPdfViaDvi() {
        return LatexDev.devViaDvi(this.pdfViaDvi);
    }

    @RuntimeParameter
    public String getDvi2pdfCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Dvi2Pdf);
    }

    public String getDvi2pdfOptions() {
        return this.dvi2pdfOptions;
    }

    public String getPatternReRunLatex() {
        return this.patternReRunLatex;
    }

    public int getMaxNumReRunsLatex() {
        return this.maxNumReRunsLatex;
    }

    public String getCommand(ConverterCategory cat) throws BuildFailureException {
        String cmdName;
        try {
            cmdName = (String)this.getClass().getDeclaredField(cat.getCommandFieldname()).get(this);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalStateException("Could not find field '" + cat.getCommandFieldname() + "' in Settings. ");
        }
        catch (IllegalAccessException iace) {
            throw new IllegalStateException("Parameter '" + cat.getCommandFieldname() + "' not readable. ");
        }
        catch (IllegalArgumentException iage) {
            throw new IllegalStateException("Settings class mismatch. ");
        }
        cmdName = this.checkConverterName(cmdName, cat);
        return cmdName;
    }

    @RuntimeParameter
    public String getBibtexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.BibTeX);
    }

    public String getBibtexOptions() {
        return this.bibtexOptions;
    }

    public String getPatternErrBibtex() {
        return this.patternErrBibtex;
    }

    public String getPatternWarnBibtex() {
        return this.patternWarnBibtex;
    }

    public String getPatternMultiIndex() {
        return this.patternMultiIndex;
    }

    @RuntimeParameter
    public String getMakeIndexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.MakeIndex);
    }

    public String getMakeIndexOptions() {
        return this.makeIndexOptions;
    }

    public String getPatternErrMakeIndex() {
        return this.patternErrMakeIndex;
    }

    public String getPatternWarnMakeIndex() {
        return this.patternWarnMakeIndex;
    }

    @RuntimeParameter
    public String getSplitIndexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.SplitIndex);
    }

    public String getSplitIndexOptions() {
        return this.splitIndexOptions;
    }

    @RuntimeParameter
    public String getMakeGlossariesCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.MakeGlossaries);
    }

    public String getMakeGlossariesOptions() {
        return this.makeGlossariesOptions;
    }

    public String getPatternWarnXindy() {
        return this.patternWarnXindy;
    }

    public String getPatternErrXindy() {
        return this.patternErrXindy;
    }

    @RuntimeParameter
    public String getPythontexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Pythontex);
    }

    public String getPythontexOptions() {
        return this.pythontexOptions;
    }

    public String getPatternErrPyTex() {
        return this.patternErrPyTex;
    }

    public String getPatternWarnPyTex() {
        return this.patternWarnPyTex;
    }

    public String getPrefixPytexOutFolder() {
        return this.prefixPytexOutFolder;
    }

    public String getTex4htCommand() {
        return this.tex4htCommand;
    }

    public String getTex4htStyOptions() {
        return this.tex4htStyOptions;
    }

    public String getTex4htOptions() {
        return this.tex4htOptions;
    }

    public String getT4htOptions() {
        return this.t4htOptions;
    }

    public String getPatternT4htOutputFiles() {
        return this.patternT4htOutputFiles;
    }

    public String getLatex2rtfCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.LaTeX2Rtf);
    }

    public String getLatex2rtfOptions() {
        return this.latex2rtfOptions;
    }

    public String getOdt2docCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Odt2Doc);
    }

    public String getOdt2docOptions() {
        return this.odt2docOptions;
    }

    public String getPdf2txtCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Pdf2Txt);
    }

    public String getPdf2txtOptions() {
        return this.pdf2txtOptions;
    }

    public String getChkTexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.LatexChk);
    }

    public String getChkTexOptions() {
        return this.chkTexOptions;
    }

    public String getVerifyStdCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.StandardValidator);
    }

    String getVerifyStdOptions() {
        return this.verifyStdOptions;
    }

    boolean getVerifyByCmp() {
        return this.verifyByCmp;
    }

    public String getDiffPdfCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.DiffPdf);
    }

    @RuntimeParameter
    public String getPdfMetainfoCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.MetaInfoPdf);
    }

    public String getPdfMetainfoOptions() {
        return this.pdfMetainfoOptions;
    }

    public String getPdfMetainfoXmpOptions() {
        return this.pdfMetainfoXmpOptions;
    }

    public String getLatexmkCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Latexmk);
    }

    public String getLatexmkOptions() {
        return this.latexmkOptions;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.texSrcDirectoryFile = new File(this.texSrcDirectory);
        this.texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
        this.texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
        this.diffDirectoryFile = new File(this.baseDirectory, this.diffDirectory);
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTargetSiteDirectory(File targetSiteDirectory) {
        this.targetSiteDirectory = targetSiteDirectory;
        this.outputDirectoryFile = new File(this.targetSiteDirectory, this.outputDirectory);
    }

    public void setTexSrcDirectory(String texSrcDirectory) {
        this.texSrcDirectory = texSrcDirectory;
        this.texSrcDirectoryFile = new File(this.texSrcDirectory);
        this.texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
    }

    public void setTexSrcProcDirectory(String texSrcProcDirectory) {
        this.texSrcProcDirectory = texSrcProcDirectory;
        this.texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
    }

    public void setReadTexSrcProcDirRec(boolean readTexSrcProcDirRec) {
        this.readTexSrcProcDirRec = readTexSrcProcDirRec;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.outputDirectoryFile = new File(this.targetSiteDirectory, this.outputDirectory);
    }

    public void setDiffDirectory(String diffDirectory) {
        this.diffDirectory = diffDirectory;
        this.diffDirectoryFile = new File(this.baseDirectory, this.diffDirectory);
    }

    public void setTargets(String targets) {
        this.targets = targets.trim();
    }

    public void setConvertersExcluded(String convertersExcluded) {
        this.convertersExcluded = convertersExcluded.trim();
    }

    public void setPatternLatexMainFile(String patternLatexMainFile) {
        this.patternLatexMainFile = patternLatexMainFile.replaceAll("(\t|\n)+", "").trim();
    }

    public PatternLatexMainFile createPatternLatexMainFile() {
        return new PatternLatexMainFile();
    }

    public void setDocClassesToTargets(String docClassesToTargets) {
        this.docClassesToTargets = docClassesToTargets;
    }

    public void setMainFilesIncluded(String mainFilesIncluded) {
        this.mainFilesIncluded = mainFilesIncluded.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setMainFilesExcluded(String mainFilesExcluded) {
        this.mainFilesExcluded = mainFilesExcluded.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setLatexmkUsage(LatexmkUsage latexmkUsage) {
        this.latexmkUsage = latexmkUsage;
    }

    public void setTexPath(File texPath) {
        this.texPath = texPath;
    }

    public void setCleanUp(boolean cleanUp) {
        this.cleanUp = cleanUp;
    }

    public void setChkDiff(boolean chkDiff) {
        this.chkDiff = chkDiff;
    }

    public void setPatternCreatedFromLatexMain(String pattern) {
        this.patternCreatedFromLatexMain = pattern.replaceAll("(\t|\n| )+", "").trim();
    }

    public PatternCreatedFromLatexMain createPatternCreatedFromLatexMain() {
        return new PatternCreatedFromLatexMain();
    }

    public void setFig2devCommand(String fig2devCommand) {
        this.fig2devCommand = fig2devCommand;
    }

    private static String beautifyOptions(String rawOption) {
        return rawOption.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setFig2devGenOptions(String fig2devGenOptions) {
        this.fig2devGenOptions = Settings.beautifyOptions(fig2devGenOptions);
    }

    public void setFig2devPtxOptions(String fig2devPtxOptions) {
        this.fig2devPtxOptions = Settings.beautifyOptions(fig2devPtxOptions);
    }

    public void setFig2devPdfEpsOptions(String fig2devPdfEpsOptions) {
        this.fig2devPdfEpsOptions = Settings.beautifyOptions(fig2devPdfEpsOptions);
    }

    public void setGnuplotCommand(String gnuplotCommand) {
        this.gnuplotCommand = gnuplotCommand;
    }

    public void setGnuplotOptions(String gnuplotOptions) {
        this.gnuplotOptions = Settings.beautifyOptions(gnuplotOptions);
    }

    public void setMetapostCommand(String metapostCommand) {
        this.metapostCommand = metapostCommand;
    }

    public void setMetapostOptions(String metapostOptions) {
        this.metapostOptions = Settings.beautifyOptions(metapostOptions);
    }

    public MetapostOptions createMetapostOptions() {
        return new MetapostOptions();
    }

    public void setPatternErrMPost(String patternErrMPost) {
        this.patternErrMPost = patternErrMPost;
    }

    public void setPatternWarnMPost(String patternWarnMPost) {
        this.patternWarnMPost = patternWarnMPost;
    }

    public void setSvg2devCommand(String svg2devCommand) {
        this.svg2devCommand = svg2devCommand;
    }

    public void setSvg2devOptions(String svg2devOptions) {
        this.svg2devOptions = Settings.beautifyOptions(svg2devOptions);
    }

    public void setCreateBoundingBoxes(boolean createBoundingBoxes) {
        this.createBoundingBoxes = createBoundingBoxes;
    }

    public void setEbbCommand(String ebbCommand) {
        this.ebbCommand = ebbCommand;
    }

    public void setEbbOptions(String ebbOptions) {
        this.ebbOptions = Settings.beautifyOptions(ebbOptions);
    }

    public void setLatex2pdfCommand(String latex2pdfCommand) {
        this.latex2pdfCommand = latex2pdfCommand;
    }

    public void setLatex2pdfOptions(String args) {
        this.latex2pdfOptions = Settings.beautifyOptions(args);
    }

    public Latex2pdfOptions createLatex2pdfOptions() {
        return new Latex2pdfOptions();
    }

    public void setPatternErrLatex(String patternErrLatex) {
        this.patternErrLatex = patternErrLatex;
    }

    public PatternErrLatex createPatternErrLatex() {
        return new PatternErrLatex();
    }

    public void setPatternWarnLatex(String patternWarnLatex) {
        this.patternWarnLatex = patternWarnLatex.replaceAll("(\t|\n)+", "").trim();
    }

    public PatternWarnLatex createPatternWarnLatex() {
        return new PatternWarnLatex();
    }

    public void setDebugBadBoxes(boolean debugBadBoxes) {
        this.debugBadBoxes = debugBadBoxes;
    }

    public void setDebugWarnings(boolean debugWarnings) {
        this.debugWarnings = debugWarnings;
    }

    public void setPdfViaDvi(boolean pdfViaDvi) {
        this.pdfViaDvi = pdfViaDvi;
    }

    public void setDvi2pdfCommand(String dvi2pdfCommand) {
        this.dvi2pdfCommand = dvi2pdfCommand;
    }

    public void setDvi2pdfOptions(String dvi2pdfOptions) {
        this.dvi2pdfOptions = dvi2pdfOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternReRunLatex(String patternReRunLatex) {
        this.patternReRunLatex = patternReRunLatex.replaceAll("(\t|\n)+", "").trim();
    }

    public PatternReRunLatex createPatternReRunLatex() {
        return new PatternReRunLatex();
    }

    public void setMaxNumReRunsLatex(int maxNumReRunsLatex) {
        assert (maxNumReRunsLatex >= 1 || maxNumReRunsLatex == -1) : "Found illegal max number of reruns " + maxNumReRunsLatex + ". ";
        this.maxNumReRunsLatex = maxNumReRunsLatex;
    }

    public void setBibtexCommand(String bibtexCommand) {
        this.bibtexCommand = bibtexCommand;
    }

    public void setBibtexOptions(String bibtexOptions) {
        this.bibtexOptions = Settings.beautifyOptions(bibtexOptions);
    }

    public void setPatternErrBibtex(String patternErrBibtex) {
        this.patternErrBibtex = patternErrBibtex;
    }

    public PatternErrBibtex createPatternErrBibtex() {
        return new PatternErrBibtex();
    }

    public void setPatternWarnBibtex(String patternWarnBibtex) {
        this.patternWarnBibtex = patternWarnBibtex;
    }

    public PatternWarnBibtex createPatternWarnBibtex() {
        return new PatternWarnBibtex();
    }

    public void setPatternMultiIndex(String patternMultiIndex) {
        this.patternMultiIndex = patternMultiIndex;
    }

    public void setMakeIndexCommand(String makeIndexCommand) {
        this.makeIndexCommand = makeIndexCommand;
    }

    public void setMakeIndexOptions(String makeIndexOptions) {
        this.makeIndexOptions = Settings.beautifyOptions(makeIndexOptions);
    }

    public void setPatternErrMakeIndex(String patternErrMakeIndex) {
        this.patternErrMakeIndex = patternErrMakeIndex.replaceAll("\n+", "").trim();
    }

    public PatternErrMakeIndex createPatternErrMakeIndex() {
        return new PatternErrMakeIndex();
    }

    public void setPatternWarnMakeIndex(String patternWarnMakeIndex) {
        this.patternWarnMakeIndex = patternWarnMakeIndex.replaceAll("\n+", "").trim();
    }

    public PatternWarnMakeIndex createPatternWarnMakeIndex() {
        return new PatternWarnMakeIndex();
    }

    public void setSplitIndexCommand(String splitIndexCommand) {
        this.splitIndexCommand = splitIndexCommand;
    }

    public void setSplitIndexOptions(String splitIndexOptions) {
        this.splitIndexOptions = Settings.beautifyOptions(splitIndexOptions);
    }

    public void setMakeGlossariesCommand(String makeGlossariesCommand) {
        this.makeGlossariesCommand = makeGlossariesCommand;
    }

    public void setMakeGlossariesOptions(String makeGlossariesOptions) {
        this.makeGlossariesOptions = Settings.beautifyOptions(makeGlossariesOptions);
    }

    public void setPatternWarnXindy(String patternWarnXindy) {
        this.patternWarnXindy = patternWarnXindy.replaceAll("\n+", "").trim();
    }

    public void setPatternErrXindy(String patternErrXindy) {
        this.patternErrXindy = patternErrXindy.replaceAll("\n+", "").trim();
    }

    public void setPythontexCommand(String pythontexCommand) {
        this.pythontexCommand = pythontexCommand;
    }

    public void setPythontexOptions(String pythontexOptions) {
        this.pythontexOptions = Settings.beautifyOptions(pythontexOptions);
    }

    public void setPatternErrPyTex(String patternErrPyTex) {
        this.patternErrPyTex = patternErrPyTex.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternWarnPyTex(String patternWarnPyTex) {
        this.patternWarnPyTex = patternWarnPyTex.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPrefixPytexOutFolder(String prefixPytexOutFolder) {
        this.prefixPytexOutFolder = prefixPytexOutFolder;
    }

    public void setTex4htCommand(String tex4htCommand) {
        this.tex4htCommand = tex4htCommand;
    }

    public void setTex4htStyOptions(String tex4htStyOptions) {
        this.tex4htStyOptions = Settings.beautifyOptions(tex4htStyOptions);
    }

    public void setTex4htOptions(String tex4htOptions) {
        this.tex4htOptions = tex4htOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setT4htOptions(String t4htOptions) {
        this.t4htOptions = Settings.beautifyOptions(t4htOptions);
    }

    public void setPatternT4htOutputFiles(String patternT4htOutputFiles) {
        this.patternT4htOutputFiles = patternT4htOutputFiles.replaceAll("(\t|\n| )+", "").trim();
    }

    public PatternT4htOutputFiles createPatternT4htOutputFiles() {
        return new PatternT4htOutputFiles();
    }

    public void setLatex2rtfCommand(String latex2rtfCommand) {
        this.latex2rtfCommand = latex2rtfCommand;
    }

    public void setLatex2rtfOptions(String latex2rtfOptions) {
        this.latex2rtfOptions = Settings.beautifyOptions(latex2rtfOptions);
    }

    public void setOdt2docCommand(String odt2docCommand) {
        this.odt2docCommand = odt2docCommand;
    }

    public void setOdt2docOptions(String odt2docOptions) {
        this.odt2docOptions = Settings.beautifyOptions(odt2docOptions);
    }

    public void setPdf2txtCommand(String pdf2txtCommand) {
        this.pdf2txtCommand = pdf2txtCommand;
    }

    public void setPdf2txtOptions(String pdf2txtOptions) {
        this.pdf2txtOptions = Settings.beautifyOptions(pdf2txtOptions);
    }

    public void setChkTexCommand(String chkTexCommand) {
        this.chkTexCommand = chkTexCommand;
    }

    public void setChkTexOptions(String chkTexOptions) {
        this.chkTexOptions = Settings.beautifyOptions(chkTexOptions);
    }

    public void setVerifyStdCommand(String verifyStdCommand) {
        this.verifyStdCommand = verifyStdCommand;
    }

    public void setVerifyStdOptions(String verifyStdOptions) {
        this.verifyStdOptions = Settings.beautifyOptions(verifyStdOptions);
    }

    public void setVerifyByCmp(boolean verifyByCmp) {
        this.verifyByCmp = verifyByCmp;
    }

    public void setDiffPdfCommand(String diffPdfCommand) {
        this.diffPdfCommand = diffPdfCommand;
    }

    public void setPdfMetainfoCommand(String pdfMetainfoCommand) {
        this.pdfMetainfoCommand = pdfMetainfoCommand;
    }

    public void setPdfMetainfoOptions(String pdfMetainfoOptions) {
        this.pdfMetainfoOptions = Settings.beautifyOptions(pdfMetainfoOptions);
    }

    public void setPdfMetainfoXmpOptions(String pdfMetainfoXmpOptions) {
        this.pdfMetainfoXmpOptions = Settings.beautifyOptions(pdfMetainfoXmpOptions);
    }

    public void setLatexmkCommand(String latexmkCommand) {
        this.latexmkCommand = latexmkCommand;
    }

    public void setLatexmkOptions(String latexmkOptions) {
        this.latexmkOptions = Settings.beautifyOptions(latexmkOptions);
    }

    public Map<String, String> getProperties() {
        Field[] fields;
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            int mod;
            Field field = fieldArray[n2];
            RuntimeParameter annot = field.getAnnotation(RuntimeParameter.class);
            if (annot != null && !Modifier.isStatic(mod = field.getModifiers())) {
                assert (!Modifier.isStatic(mod)) : "found static parameter " + String.valueOf(field) + ". ";
                assert (!Modifier.isFinal(mod)) : "found final parameter " + String.valueOf(field) + ". ";
                assert (Modifier.isPrivate(mod)) : "found non-private parameter " + String.valueOf(field) + ". ";
                String name = field.getName();
                field.setAccessible(true);
                try {
                    Object value = field.get(this);
                    res.put(name, value == null ? null : value.toString());
                }
                catch (IllegalArgumentException iare) {
                    throw new IllegalStateException("Found no field '" + name + "' in setting. ");
                }
                catch (IllegalAccessException iace) {
                    throw new IllegalStateException("Illegal access to field '" + name + "' although set accessible. ");
                }
            }
            ++n2;
        }
        return res;
    }

    public Map<String, String> getMethodsNoParams() {
        Method[] methods;
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        Method[] methodArray = methods = this.getClass().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            RuntimeParameter annot = method.getAnnotation(RuntimeParameter.class);
            if (annot != null) {
                int mod = method.getModifiers();
                assert (method.getParameterTypes().length == 0) : "found getter with parameter. ";
                assert (!Modifier.isStatic(mod)) : "found static getter. ";
                String name = method.getName();
                method.setAccessible(true);
                try {
                    Object value = method.invoke((Object)this, new Object[0]);
                    res.put(name, value == null ? null : value.toString());
                }
                catch (IllegalArgumentException iare) {
                    throw new IllegalStateException("Found no method '" + name + "()' in setting. ");
                }
                catch (IllegalAccessException iace) {
                    throw new IllegalStateException("Illegal access to method '" + name + "' although set accessible. ");
                }
                catch (InvocationTargetException ite) {
                    throw new IllegalStateException("Invocation of method '" + name + "()' caused exception. ", ite);
                }
            }
            ++n2;
        }
        return res;
    }

    File rcResourceToFile(String fileNameResource) {
        String dir = System.getProperty(PARAM_PROP) == null ? this.texSrcDirectory : ".";
        return new File(dir, fileNameResource);
    }

    public void filterInjection(InputStream inStream, PrintStream writer, String version, Injection inj) throws IOException {
        String strLine;
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream));
        Pattern pattern = inj.doFilter() ? PATTERN_CONFIG : NEVER_MATCH;
        Map<String, String> props = this.getProperties();
        Map<String, String> getters = this.getMethodsNoParams();
        if (inj.hasShebang()) {
            strLine = bufReader.readLine();
            assert (strLine != null);
            writer.println(strLine);
        }
        writer.println(inj.commentStr() + " injection file written by latex plugin " + version);
        block0: while ((strLine = bufReader.readLine()) != null) {
            while (true) {
                String replacement;
                Matcher matcher;
                if (!(matcher = pattern.matcher((CharSequence)strLine)).find()) {
                    writer.println(strLine);
                    continue block0;
                }
                assert (matcher.groupCount() >= 1);
                System.out.println("line: |" + strLine + "|");
                System.out.println("key:  |" + matcher.group(GRP_NAME) + "|");
                System.out.println("val:  |" + props.get(matcher.group(GRP_NAME)) + "|");
                if (matcher.group(GRP_METHOD) == null) {
                    assert (props.containsKey(matcher.group(GRP_NAME))) : "Key '" + matcher.group("name") + "' not found. ";
                    replacement = props.get(matcher.group(GRP_NAME));
                } else {
                    assert (getters.containsKey(matcher.group(GRP_NAME))) : "Key '" + matcher.group("name") + "' not found. ";
                    replacement = getters.get(matcher.group(GRP_NAME));
                }
                System.out.println("rep1: |" + replacement + "|");
                replacement = StringEscapeUtils.escapeJava((String)replacement).replace("\\", "\\\\");
                System.out.println("rep2: |" + replacement + "|");
                strLine = matcher.replaceFirst(replacement);
            }
        }
        writer.flush();
        writer.close();
    }

    public String toString() {
        ArrayList<CallSite> res = new ArrayList<CallSite>();
        Map<String, String> name2value = this.getProperties();
        for (Map.Entry<String, String> entry : name2value.entrySet()) {
            res.add((CallSite)((Object)(entry.getKey() + "='" + entry.getValue() + "'")));
        }
        return ((Object)res).toString();
    }

    public static void main(String[] args) {
        System.out.println("texpath: " + String.valueOf(new Settings().getTexPath()));
    }

    public class Latex2pdfOptions {
        public void addText(String args) {
            Settings.this.setLatex2pdfOptions(args);
        }
    }

    public class MetapostOptions {
        public void addText(String args) {
            Settings.this.setMetapostOptions(args);
        }
    }

    public class PatternCreatedFromLatexMain {
        public void addText(String pattern) {
            Settings.this.setPatternCreatedFromLatexMain(pattern);
        }
    }

    public class PatternErrBibtex {
        public void addText(String pattern) {
            Settings.this.setPatternErrBibtex(pattern);
        }
    }

    public class PatternErrLatex {
        public void addText(String pattern) {
            Settings.this.setPatternErrLatex(pattern);
        }
    }

    public class PatternErrMakeIndex {
        public void addText(String pattern) {
            Settings.this.setPatternErrMakeIndex(pattern);
        }
    }

    public class PatternLatexMainFile {
        public void addText(String pattern) {
            Settings.this.setPatternLatexMainFile(pattern);
        }
    }

    public class PatternReRunLatex {
        public void addText(String pattern) {
            Settings.this.setPatternReRunLatex(pattern);
        }
    }

    public class PatternT4htOutputFiles {
        public void addText(String pattern) {
            Settings.this.setPatternT4htOutputFiles(pattern);
        }
    }

    public class PatternWarnBibtex {
        public void addText(String pattern) {
            Settings.this.setPatternWarnBibtex(pattern);
        }
    }

    public class PatternWarnLatex {
        public void addText(String pattern) {
            Settings.this.setPatternWarnLatex(pattern);
        }
    }

    public class PatternWarnMakeIndex {
        public void addText(String pattern) {
            Settings.this.setPatternWarnMakeIndex(pattern);
        }
    }
}

