/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DirNode {
    private static final FileFilter PASS_ALL_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return true;
        }
    };
    private final Set<String> regularFileNames;
    private final Map<String, DirNode> name2node;

    public DirNode(File dir, TexFileUtils fileUtils) {
        assert (dir.isDirectory()) : "The file '" + String.valueOf(dir) + "' is no directory. ";
        File[] files = fileUtils.listFilesOrWarn(dir, PASS_ALL_FILE_FILTER);
        if (files == null) {
            assert (false);
            this.regularFileNames = null;
            this.name2node = null;
            return;
        }
        this.regularFileNames = new TreeSet<String>();
        this.name2node = new TreeMap<String, DirNode>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            assert (Files.exists(file.toPath(), LinkOption.NOFOLLOW_LINKS)) : "The file '" + String.valueOf(file) + "' does not exist. ";
            if (file.isDirectory()) {
                DirNode node = new DirNode(file, fileUtils);
                if (node.isValid()) {
                    this.name2node.put(file.getName(), node);
                }
            } else {
                this.regularFileNames.add(file.getName());
            }
            ++n2;
        }
    }

    boolean isValid() {
        assert (this.regularFileNames == null == (this.name2node == null));
        return this.regularFileNames != null;
    }

    Set<String> getRegularFileNames() {
        return this.regularFileNames;
    }

    Map<String, DirNode> getSubdirs() {
        return this.name2node;
    }
}

