/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexMainParameterNames;
import eu.simuline.m2latex.core.LogWrapper;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

class DocumentMetadata {
    private static final Pattern PATTERN_METADATA = Pattern.compile((String)"(\\s*,\\s*)?(?<key>[-a-z]+)(?:\\s*=\\s*(?<value>[^{}, ]+|\\{[^{}]*\\}))?");
    private static final String KEY_PDFVERSION = "pdfversion";
    private static final String KEY_UNCOMP = "uncompress";
    private static final String KEY_STD = "pdfstandard";
    private static final String KEY_XMP = "xmp";
    private static final String KEY_TAGGING = "tagging";
    private final LogWrapper log;
    private final Map<String, String> key2value;
    final Optional<String> pdfversion;
    final boolean isCompressed;
    final boolean withXMP;
    final TaggingState tagging;

    private static String unwrap(String str) {
        return (str = str.trim()).startsWith("{") && str.endsWith("}") ? str.substring(1, str.length() - 1) : str;
    }

    DocumentMetadata(LatexMainDesc desc, LogWrapper log) {
        Optional<String> stdU;
        Optional<String> stdA;
        Optional<String> docMetadataValue = desc.groupMatch(LatexMainParameterNames.docMetadata);
        this.log = log;
        if (docMetadataValue.isEmpty()) {
            this.key2value = null;
            this.withXMP = false;
            this.isCompressed = true;
            this.pdfversion = Optional.empty();
            this.tagging = TaggingState.off;
            this.log.debug("No DocumentMetadata{...} found.");
            return;
        }
        String docMetadataString = docMetadataValue.get();
        this.key2value = new TreeMap<String, String>();
        Matcher matcher = PATTERN_METADATA.matcher((CharSequence)docMetadataString);
        block8: while (matcher.find()) {
            String key = matcher.group("key");
            String valNew = matcher.group("value");
            System.out.println("key: |" + key + "| value: |" + valNew + "|");
            switch (key) {
                case "pdfstandard": {
                    String valOrg = this.key2value.get(KEY_STD);
                    if (valNew == null) {
                        this.log.warn(String.format("DMxx: Ignoring key '%s' specified without expected value.", key));
                        break;
                    }
                    assert (valNew != null);
                    valNew = DocumentMetadata.unwrap(valNew).toLowerCase();
                    String valRep = valOrg == null ? valNew : valOrg + "," + valNew;
                    this.key2value.put(KEY_STD, valRep);
                    break;
                }
                case "uncompress": {
                    if (valNew != null) {
                        this.log.warn(String.format("DMxx: Unexpected value '%s' for key '%s' will cause a compilation error.", valNew, key));
                        break;
                    }
                    if (this.key2value.keySet().contains(key)) {
                        this.log.warn(String.format("DMxx: Found specifying '%s' more than once.", key));
                        break;
                    }
                    this.key2value.put(key, null);
                    break;
                }
                default: {
                    if (valNew == null) {
                        this.log.warn(String.format("DMxx: Ignoring key '%s' specified without expected value.", key));
                        break;
                    }
                    String valOrg = this.key2value.put(key, valNew);
                    if (valOrg == null) continue block8;
                    this.log.warn(String.format("DMxx: Overwritten internally value '%s' by '%s' for key '%s'.", valOrg, valNew, key));
                }
            }
        }
        this.pdfversion = this.key2value.containsKey(KEY_PDFVERSION) ? Optional.of(this.key2value.get(KEY_PDFVERSION)) : Optional.empty();
        this.isCompressed = !this.key2value.containsKey(KEY_UNCOMP);
        this.withXMP = this.key2value.containsKey(KEY_XMP) ? Boolean.parseBoolean(this.key2value.get(KEY_XMP)) : true;
        this.tagging = this.key2value.containsKey(KEY_TAGGING) ? TaggingState.valueOf(this.key2value.get(KEY_TAGGING)) : TaggingState.off;
        Optional<String> stdX = this.claimedStandard(StdType.x);
        if (stdX.isPresent()) {
            this.log.warn(String.format("DMxx: Specified standard %s which cannot be verified. ", stdX.get()));
        }
        if ((stdA = this.claimedStandard(StdType.a)).isPresent()) {
            this.log.info(String.format("Specified standard %s to be verified later. ", stdA.get()));
        }
        if ((stdU = this.claimedStandard(StdType.ua)).isPresent()) {
            if (this.tagging == TaggingState.on) {
                this.log.info("Specified standard " + stdU.get() + " to be verified later. ");
            } else {
                this.log.warn("Specified standard " + stdU.get() + " without tagging; verification will fail. ");
            }
        }
        if (this.tagging == TaggingState.draft) {
            this.log.warn("DMxx: Still tagging is set to 'draft'. ");
        }
        if ((stdX.isPresent() || stdA.isPresent() || stdU.isPresent()) && !this.withXMP) {
            this.log.warn("DMxx: Specified standard without XMP; verification will fail. ");
        }
    }

    boolean mustTriggerVerification() {
        return this.claimedStandard(StdType.a).isPresent() || this.claimedStandard(StdType.ua).isPresent();
    }

    Optional<String> claimedStandard(StdType stdType) {
        if (this.key2value == null) {
            return Optional.empty();
        }
        String stdsStr = this.key2value.get(KEY_STD);
        if (stdsStr == null) {
            return Optional.empty();
        }
        Matcher matcher = Pattern.compile((String)String.format("^(.*,)?(?<std>%s-\\d+[a-z]*)", stdType.toString())).matcher((CharSequence)stdsStr);
        return matcher.find() ? Optional.of(matcher.group("std")) : Optional.empty();
    }

    static enum StdType {
        ua,
        a,
        x;

    }

    static enum TaggingState {
        on,
        off,
        draft;

    }
}

